import http from '@/api/http';
import { AxiosError } from 'axios';
import { History } from 'history';

export const setupInterceptors = (history: History) => {
    http.interceptors.response.use(resp => resp, (error: AxiosError) => {
        if (error.response?.status === 400) {
            if (error.response?.data.errors?.[0].code === 'TwoFactorAuthRequiredException') {
                if (!window.location.pathname.startsWith('/account')) {
                    history.replace('/account', { twoFactorRedirect: true });
                }
            }
        }
        throw error;
    });
};
